document.addEventListener('DOMContentLoaded', () => {
    
    // === Burger Menu Toggle ===
    const burger = document.querySelector('.burger');
    const mobileMenu = document.querySelector('.mobile-menu');
    const mobileLinks = document.querySelectorAll('.mobile-menu__link');

    if (burger) {
        burger.addEventListener('click', () => {
            mobileMenu.classList.toggle('active');
            burger.classList.toggle('active'); // You might want to animate burger to X
            
            // Animate burger lines
            const spans = burger.querySelectorAll('span');
            if (mobileMenu.classList.contains('active')) {
                spans[0].style.transform = 'rotate(45deg) translate(5px, 5px)';
                spans[1].style.transform = 'rotate(-45deg) translate(5px, -5px)';
            } else {
                spans[0].style.transform = 'none';
                spans[1].style.transform = 'none';
            }
        });
    }

    mobileLinks.forEach(link => {
        link.addEventListener('click', () => {
            mobileMenu.classList.remove('active');
            const spans = burger.querySelectorAll('span');
            spans[0].style.transform = 'none';
            spans[1].style.transform = 'none';
        });
    });

    // === Phone Mask ===
    const phoneInput = document.getElementById('phone');
    if (phoneInput) {
        phoneInput.addEventListener('input', function (e) {
            let x = e.target.value.replace(/\D/g, '').match(/(\d{0,1})(\d{0,3})(\d{0,3})(\d{0,2})(\d{0,2})/);
            if (!x[2]) {
                e.target.value = x[1] ? '+7' : '';
            } else {
                e.target.value = !x[3] ? `+7 (${x[2]}` : `+7 (${x[2]}) ${x[3]}` + (x[4] ? `-${x[4]}` : '') + (x[5] ? `-${x[5]}` : '');
            }
        });
    }

    // === Form Submission Simulation ===
    const form = document.getElementById('joinForm');
    const statusDiv = document.querySelector('.form__status');
    const btn = document.querySelector('.btn--submit');
    const btnText = btn.querySelector('span');

    if (form) {
        form.addEventListener('submit', (e) => {
            e.preventDefault();
            
            // Basic validation
            const name = document.getElementById('name').value;
            const phone = document.getElementById('phone').value;
            const email = document.getElementById('email').value;

            if (name && phone.length >= 16 && email) {
                // Determine original button content
                const originalText = btnText.innerText;
                
                // Loading state
                btnText.innerText = 'ОТПРАВКА...';
                btn.style.opacity = '0.7';
                btn.disabled = true;

                setTimeout(() => {
                    // Success state
                    btnText.innerText = 'ОТПРАВЛЕНО';
                    btn.style.backgroundColor = '#22c55e'; // Success Green
                    btn.style.opacity = '1';
                    
                    statusDiv.innerText = 'Данные зашифрованы и переданы. Ожидайте связи.';
                    statusDiv.classList.add('success');
                    
                    form.reset();

                    // Reset button after 3 seconds
                    setTimeout(() => {
                        btnText.innerText = originalText;
                        btn.style.backgroundColor = '';
                        btn.disabled = false;
                        statusDiv.innerText = '';
                        statusDiv.classList.remove('success');
                    }, 3000);

                }, 1500); // Simulate network delay
            } else {
                statusDiv.innerText = 'Пожалуйста, заполните все поля корректно.';
                statusDiv.style.color = 'red';
            }
        });
    }

    // === Reveal Animations on Scroll ===
    const observerOptions = {
        threshold: 0.1
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);

    document.querySelectorAll('.philosophy__card, .join__content').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });

    // Add visible class styling dynamically or in CSS
    // Let's add the listener to handle the visibility change
    const style = document.createElement('style');
    style.innerHTML = `
        .visible {
            opacity: 1 !important;
            transform: translateY(0) !important;
        }
    `;
    document.head.appendChild(style);
});
