document.addEventListener('DOMContentLoaded', () => {
    // 1. BURGER MENU
    const burger = document.getElementById('burger');
    const nav = document.getElementById('nav');
    const navLinks = document.querySelectorAll('.nav__link');

    burger.addEventListener('click', () => {
        burger.classList.toggle('active');
        nav.classList.toggle('active');
        document.body.classList.toggle('no-scroll');
    });

    navLinks.forEach(link => {
        link.addEventListener('click', () => {
            burger.classList.remove('active');
            nav.classList.remove('active');
            document.body.classList.remove('no-scroll');
        });
    });

    // 2. TOXIC PREDICTIONS LOGIC
    const predictionForm = document.getElementById('predictionForm');
    const terminal = document.getElementById('terminal');
    const userInput = document.getElementById('userInput');

    const toxicAnswers = [
        "Твои шансы на успех ниже, чем вероятность того, что ты сейчас выключишь этот сайт.",
        "Завтра будет так же плохо, как и сегодня. Но хотя бы ты к этому привык.",
        "Твоё будущее настолько темное, что даже мой OLED-экран не справляется.",
        "Прогноз: Ты снова потратишь вечер на ерунду и будешь жалеть об этом утром.",
        "У меня для тебя плохие новости. Но я скажу их тебе только за деньги. Хотя нет, бесплатно: ты безнадежен.",
        "Звезды говорят, что тебе стоит перестать задавать тупые вопросы ботам.",
        "Я проанализировал твой IP. Мои соболезнования твоему провайдеру.",
        "Твой успех ждет тебя за углом. Жаль, что ты ходишь только по кругу.",
        "Сегодня — идеальный день для того, чтобы ничего не делать. Ты в этом мастер."
    ];

    function addTerminalLine(text, type = '') {
        const p = document.createElement('p');
        p.className = `terminal__line ${type ? 'terminal__line--' + type : ''}`;
        p.textContent = text;
        terminal.appendChild(p);
        terminal.scrollTop = terminal.scrollHeight;
    }

    predictionForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const question = userInput.value;
        if (!question) return;

        // Simulate processing
        addTerminalLine(`> Вопрос: ${question}`);
        addTerminalLine('Анализирую уровень твоей наивности...', 'system');

        const submitBtn = predictionForm.querySelector('button');
        submitBtn.disabled = true;
        submitBtn.textContent = 'ДУМАЮ...';

        setTimeout(() => {
            const randomAnswer = toxicAnswers[Math.floor(Math.random() * toxicAnswers.length)];
            addTerminalLine(randomAnswer, 'success');
            
            userInput.value = '';
            submitBtn.disabled = false;
            submitBtn.textContent = 'УНИЗИТЬ МЕНЯ';
            
            // Simulation of successful "message sent" (imitation)
            setTimeout(() => {
                addTerminalLine('Данные о твоем позоре успешно сохранены в облаке.', 'system');
            }, 1000);
        }, 1500);
    });

    // 3. INPUT MASK SIMULATION
    userInput.addEventListener('input', (e) => {
        const mask = document.querySelector('.input-mask');
        if (e.target.value.length > 0) {
            mask.style.opacity = '0';
        } else {
            mask.style.opacity = '1';
        }
    });

    // 4. SMOOTH SCROLL (Enhanced)
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            if (targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 80,
                    behavior: 'smooth'
                });
            }
        });
    });

    // 5. OBSERVER FOR FADE-IN
    const observerOptions = {
        threshold: 0.1
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    document.querySelectorAll('.section, .feature-card').forEach(el => {
        el.style.opacity = '0';
        el.style.transition = 'opacity 0.8s ease-out, transform 0.8s ease-out';
        el.style.transform = 'translateY(20px)';
        observer.observe(el);
    });

    // Helper to trigger visibility
    window.addEventListener('scroll', () => {
        document.querySelectorAll('.section, .feature-card').forEach(el => {
            if (el.getBoundingClientRect().top < window.innerHeight * 0.8) {
                el.style.opacity = '1';
                el.style.transform = 'translateY(0)';
            }
        });
    });
});
